/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.mrcrayfish.configured.api.IConfigValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeValue<T>
implements IConfigValue<T> {
    public final ForgeConfigSpec.ConfigValue<T> configValue;
    public final ForgeConfigSpec.ValueSpec valueSpec;
    protected final T initialValue;
    protected T value;
    protected Pair<T, T> range;
    protected Component validationHint;

    public ForgeValue(ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        this.configValue = configValue;
        this.valueSpec = valueSpec;
        this.initialValue = configValue.get();
        this.set(configValue.get());
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.get(), this.valueSpec.getDefault());
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.get(), this.initialValue);
    }

    @Override
    public void restore() {
        this.set(this.getDefault());
    }

    @Override
    public T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    @Override
    public boolean isValid(T value) {
        return this.valueSpec.test(value);
    }

    @Override
    public String getComment() {
        return this.valueSpec.getComment();
    }

    @Override
    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Override
    @Nullable
    public Component getValidationHint() {
        if (this.validationHint == null) {
            this.loadRange();
            if (this.range != null && this.range.getLeft() != null && this.range.getRight() != null) {
                this.validationHint = new TranslatableComponent("configured.validator.range_hint", new Object[]{this.range.getLeft().toString(), this.range.getRight().toString()});
            }
        }
        return this.validationHint;
    }

    @Override
    public String getName() {
        return ForgeValue.lastValue(this.configValue.getPath(), "");
    }

    @Override
    public void cleanCache() {
        this.configValue.clearCache();
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.valueSpec.needsWorldRestart();
    }

    @Override
    public boolean requiresGameRestart() {
        return false;
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    public void loadRange() {
        if (this.range == null) {
            try {
                Object range = ObfuscationReflectionHelper.getPrivateValue(ForgeConfigSpec.ValueSpec.class, (Object)this.valueSpec, (String)"range");
                if (range != null) {
                    Class<?> rangeClass = Class.forName("net.minecraftforge.common.ForgeConfigSpec$Range");
                    Object min = ObfuscationReflectionHelper.getPrivateValue(rangeClass, (Object)range, (String)"min");
                    Object max = ObfuscationReflectionHelper.getPrivateValue(rangeClass, (Object)range, (String)"max");
                    this.range = Pair.of((Object)min, (Object)max);
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.range = Pair.of(null, null);
        }
    }
}

